/**
 * Script de correction des distances - VERSION DEBUG AVANCÉ
 * Cette version contient des instructions de débogage détaillées
 */

// Attendre que la page soit complètement chargée
window.addEventListener('load', function() {
    console.log("=== SCRIPT DE CORRECTION DES DISTANCES DÉMARRÉ ===");
    console.log("Version: DEBUG AVANCÉ - " + new Date().toISOString());
    
    // Fonction pour inspecter un élément DOM
    function inspectElement(element, label) {
        if (!element) {
            console.error("INSPECTION: " + label + " - ÉLÉMENT NULL");
            return;
        }
        
        console.log("INSPECTION: " + label);
        console.log("- tagName: " + element.tagName);
        console.log("- id: " + element.id);
        console.log("- className: " + element.className);
        console.log("- innerHTML: " + element.innerHTML.substring(0, 100) + (element.innerHTML.length > 100 ? "..." : ""));
        console.log("- style.display: " + element.style.display);
        console.log("- offsetWidth: " + element.offsetWidth);
        console.log("- offsetHeight: " + element.offsetHeight);
        
        // Vérifier si l'élément est visible
        const rect = element.getBoundingClientRect();
        console.log("- getBoundingClientRect: ", 
                    "top=" + rect.top, 
                    "left=" + rect.left, 
                    "width=" + rect.width, 
                    "height=" + rect.height);
        
        // Vérifier les styles calculés
        const computedStyle = window.getComputedStyle(element);
        console.log("- computedStyle.display: " + computedStyle.display);
        console.log("- computedStyle.visibility: " + computedStyle.visibility);
        console.log("- computedStyle.opacity: " + computedStyle.opacity);
    }
    
    // Attendre 2 secondes pour s'assurer que tous les autres scripts sont terminés
    console.log("Attente de 2 secondes avant correction...");
    setTimeout(function() {
        console.log("Délai écoulé, début de la correction");
        
        // Fonction pour corriger l'affichage des distances
        function fixDistanceDisplay() {
            console.log("=== DÉBUT DE LA CORRECTION DES DISTANCES ===");
            console.log("Heure: " + new Date().toISOString());
            
            // Récupérer tous les conteneurs de distance
            const distanceContainers = document.querySelectorAll('.farmer-distance');
            console.log("Nombre de conteneurs de distance trouvés: " + distanceContainers.length);
            
            // Inspecter le document pour voir s'il y a des éléments avec la classe farmer-distance
            console.log("VÉRIFICATION DU DOM COMPLET:");
            console.log("- Tous les éléments dans le document: " + document.querySelectorAll('*').length);
            console.log("- Éléments avec classe 'farmer-distance': " + document.querySelectorAll('.farmer-distance').length);
            console.log("- Éléments avec classe 'distance-value': " + document.querySelectorAll('.distance-value').length);
            
            // Si aucun conteneur trouvé, essayer de rechercher plus largement
            if (distanceContainers.length === 0) {
                console.warn("Aucun conteneur de distance trouvé avec la classe 'farmer-distance'");
                console.log("Recherche d'éléments contenant 'distance' dans leur classe...");
                
                const allElements = document.querySelectorAll('*');
                let potentialContainers = [];
                
                for (let i = 0; i < allElements.length; i++) {
                    const el = allElements[i];
                    if (el.className && typeof el.className === 'string' && 
                        (el.className.includes('distance') || el.id && el.id.includes('distance'))) {
                        potentialContainers.push(el);
                        console.log("Élément potentiel trouvé: ", el.tagName, el.className, el.id);
                    }
                }
                
                console.log("Éléments potentiels trouvés: " + potentialContainers.length);
            }
            
            // Parcourir chaque conteneur
            let successCount = 0;
            let errorCount = 0;
            
            distanceContainers.forEach(function(container, index) {
                console.log("=== TRAITEMENT DU CONTENEUR #" + index + " ===");
                
                try {
                    // Inspecter le conteneur
                    inspectElement(container, "Conteneur de distance #" + index);
                    
                    // Récupérer l'ID du conteneur
                    const id = container.id ? container.id.replace('distance-', '') : 'inconnu-' + index;
                    console.log("Traitement du conteneur ID: " + id);
                    
                    // Récupérer la valeur de distance actuelle
                    const valueElement = container.querySelector('.distance-value');
                    console.log("Élément de valeur trouvé: " + (valueElement ? "OUI" : "NON"));
                    
                    if (!valueElement) {
                        console.warn("Élément de valeur introuvable pour ID " + id);
                        console.log("Contenu HTML du conteneur: " + container.innerHTML);
                        
                        // Essayer de créer un nouvel élément de valeur
                        console.log("Tentative de création d'un nouvel élément de valeur");
                        const newValueElement = document.createElement('p');
                        newValueElement.className = 'distance-value';
                        newValueElement.textContent = "0.0";
                        newValueElement.style.color = '#ff0000';
                        newValueElement.style.fontWeight = 'bold';
                        
                        // Ajouter l'élément de valeur au conteneur
                        container.innerHTML = ''; // Vider le conteneur
                        container.appendChild(newValueElement);
                        
                        // Ajouter l'élément d'unité
                        const unitElement = document.createElement('p');
                        unitElement.className = 'distance-unit';
                        unitElement.textContent = 'km';
                        container.appendChild(unitElement);
                        
                        console.log("Nouvel élément de valeur créé et ajouté");
                        
                        // Continuer avec le nouvel élément
                        continue;
                    }
                    
                    // Inspecter l'élément de valeur
                    inspectElement(valueElement, "Élément de valeur pour ID " + id);
                    
                    // Récupérer la valeur numérique
                    let distanceValue = parseFloat(valueElement.textContent);
                    console.log("Valeur textuelle: '" + valueElement.textContent + "'");
                    console.log("Valeur numérique parsée: " + distanceValue);
                    
                    // Si la distance est 0, essayer de récupérer la distance depuis l'attribut data-distance
                    if (distanceValue === 0 || isNaN(distanceValue)) {
                        console.log("Valeur nulle ou invalide, recherche dans data-distance");
                        
                        const parentItem = container.closest('.farmer-item, .grid-item');
                        console.log("Élément parent trouvé: " + (parentItem ? "OUI" : "NON"));
                        
                        if (parentItem) {
                            console.log("Attributs data-* du parent:");
                            for (let attr of parentItem.attributes) {
                                if (attr.name.startsWith('data-')) {
                                    console.log("- " + attr.name + ": " + attr.value);
                                }
                            }
                        }
                        
                        if (parentItem && parentItem.hasAttribute('data-distance')) {
                            distanceValue = parseFloat(parentItem.getAttribute('data-distance'));
                            console.log("Valeur récupérée depuis data-distance: " + distanceValue);
                        } else {
                            console.warn("Aucune valeur de distance trouvée dans data-distance");
                        }
                    }
                    
                    // Si nous avons une valeur valide, mettre à jour l'affichage
                    if (distanceValue > 0) {
                        console.log("Valeur valide trouvée: " + distanceValue + ", mise à jour de l'affichage");
                        
                        // MÉTHODE 1: Créer un nouvel élément et remplacer l'ancien
                        try {
                            console.log("MÉTHODE 1: Remplacement de l'élément");
                            
                            // Créer un nouvel élément pour remplacer l'ancien
                            const newValueElement = document.createElement('p');
                            newValueElement.className = 'distance-value';
                            newValueElement.textContent = distanceValue.toFixed(1);
                            newValueElement.style.color = '#ff0000';
                            newValueElement.style.fontWeight = 'bold';
                            
                            console.log("Nouvel élément créé: " + newValueElement.outerHTML);
                            
                            // Remplacer l'ancien élément
                            if (valueElement.parentNode) {
                                valueElement.parentNode.replaceChild(newValueElement, valueElement);
                                console.log("Élément remplacé avec succès");
                            } else {
                                console.error("Impossible de remplacer l'élément: parent introuvable");
                            }
                        } catch (methodError) {
                            console.error("Erreur avec MÉTHODE 1:", methodError);
                            
                            // MÉTHODE 2: Modifier directement l'élément existant
                            try {
                                console.log("MÉTHODE 2: Modification directe");
                                valueElement.textContent = distanceValue.toFixed(1);
                                valueElement.style.color = '#ff0000';
                                valueElement.style.fontWeight = 'bold';
                                console.log("Élément modifié directement");
                            } catch (method2Error) {
                                console.error("Erreur avec MÉTHODE 2:", method2Error);
                                
                                // MÉTHODE 3: Utiliser innerHTML
                                try {
                                    console.log("MÉTHODE 3: Utilisation de innerHTML");
                                    container.innerHTML = '<p class="distance-value" style="color: #ff0000; font-weight: bold;">' + 
                                                        distanceValue.toFixed(1) + 
                                                        '</p><p class="distance-unit">km</p>';
                                    console.log("innerHTML mis à jour");
                                } catch (method3Error) {
                                    console.error("Erreur avec MÉTHODE 3:", method3Error);
                                }
                            }
                        }
                        
                        // Mettre à jour les styles du conteneur
                        try {
                            console.log("Mise à jour des styles du conteneur");
                            container.style.backgroundColor = '#e9f5dc';
                            container.style.display = 'flex';
                            console.log("Styles du conteneur mis à jour");
                            
                            // Forcer le rafraîchissement du rendu
                            container.offsetHeight; // Truc pour forcer un reflow
                        } catch (styleError) {
                            console.error("Erreur lors de la mise à jour des styles:", styleError);
                        }
                        
                        console.log("Affichage mis à jour pour ID " + id + ": " + distanceValue.toFixed(1) + " km");
                        successCount++;
                    } else {
                        console.warn("Aucune valeur valide trouvée pour ID " + id);
                        errorCount++;
                    }
                } catch (error) {
                    console.error("Erreur lors de la correction du conteneur #" + index + ":", error);
                    errorCount++;
                }
            });
            
            console.log("=== FIN DE LA CORRECTION DES DISTANCES ===");
            console.log("Résultats: " + successCount + " succès, " + errorCount + " erreurs");
            
            // Vérifier l'état final des éléments
            console.log("VÉRIFICATION FINALE:");
            const finalContainers = document.querySelectorAll('.farmer-distance');
            console.log("Nombre final de conteneurs: " + finalContainers.length);
            
            finalContainers.forEach(function(container, index) {
                if (index < 5) { // Limiter à 5 pour éviter de surcharger la console
                    const valueEl = container.querySelector('.distance-value');
                    console.log("Conteneur #" + index + ":");
                    console.log("- display: " + container.style.display);
                    console.log("- backgroundColor: " + container.style.backgroundColor);
                    console.log("- valeur: " + (valueEl ? valueEl.textContent : "non trouvé"));
                }
            });
        }
        
        // Exécuter la fonction de correction
        fixDistanceDisplay();
        
        // Ajouter un gestionnaire d'événement au bouton de géolocalisation
        console.log("Recherche des boutons de géolocalisation...");
        const geolocateButtons = document.querySelectorAll('.geolocation-button');
        console.log("Nombre de boutons trouvés: " + geolocateButtons.length);
        
        geolocateButtons.forEach(function(button, index) {
            console.log("Configuration du bouton #" + index + ":", button.id || 'sans ID');
            inspectElement(button, "Bouton de géolocalisation #" + index);
            
            // Ajouter un gestionnaire qui s'exécutera après le calcul des distances
            button.addEventListener('click', function() {
                console.log("CLIC DÉTECTÉ sur le bouton de géolocalisation #" + index);
                console.log("Planification des corrections...");
                
                // Attendre 5 secondes après le clic (temps estimé pour le calcul des distances)
                console.log("Première correction planifiée dans 5 secondes");
                setTimeout(function() {
                    console.log("Exécution de la correction après 5 secondes");
                    fixDistanceDisplay();
                }, 5000);
                
                // Puis vérifier toutes les 2 secondes pendant 20 secondes
                let checkCount = 0;
                const intervalId = setInterval(function() {
                    checkCount++;
                    console.log("Exécution de la correction #" + checkCount + " (intervalle de 2 secondes)");
                    fixDistanceDisplay();
                    
                    // Arrêter après 10 vérifications (20 secondes)
                    if (checkCount >= 10) {
                        console.log("Fin des vérifications périodiques après 10 tentatives");
                        clearInterval(intervalId);
                    }
                }, 2000);
            });
            
            console.log("Gestionnaire d'événement ajouté au bouton #" + index);
        });
        
        console.log("=== SCRIPT DE CORRECTION DES DISTANCES INITIALISÉ ===");
        console.log("Heure: " + new Date().toISOString());
    }, 2000);
});
